/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetworkInterfaceInformation;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.util.List;

public class LanAdaptersBean
extends PanelBean
implements SettingsConstants {
    private String m_sLanAdapter;
    private ValueDescriptor[] m_cdLanAdapter;
    private String[] lanAdapterList;
    private int num_LanAdapters;
    private List _ifs;
    private Integer rowSelected;
    private String command = "";
    private String[] macaddrText;
    private static final String TRACE_MASKT = "XSETLABT";
    private static final String TRACE_MASKF = "XSETLABF";
    private static final String TRACE_MASKD = "XSETLABD";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(85, "LanAdaptersBean");
    private transient boolean dataChangedFlag;

    public String getLanAdapter() {
        return this.m_sLanAdapter;
    }

    public void setLanAdapter(String s) throws IllegalUserDataException {
        this.m_sLanAdapter = s;
        Trace.trace(TRACE_MASKT, "<> LanAdaptersBean.setLanAdapter [" + s + "]");
    }

    public ValueDescriptor[] getLanAdapterList() {
        int i = 0;
        while (i < this.m_cdLanAdapter.length) {
            Trace.trace(TRACE_MASKT, "ValueDescriptor: getLanAdapterList = [" + this.m_cdLanAdapter[i].getName() + " , " + this.m_cdLanAdapter[i].getTitle() + "]");
            ++i;
        }
        return this.m_cdLanAdapter;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public boolean getDataChanged() {
        return this.dataChangedFlag;
    }

    public void setDataChanged() {
        Trace.trace(TRACE_MASKT, "NetworkInfoBean: setDataChanged()");
        this.dataChangedFlag = true;
    }

    public void panelAction(TaskActionEvent event) {
        this.command = event.getElementName();
        Trace.trace(TRACE_MASKT, "-> LanAdaptersBean.panelAction():  " + this.command);
        Object uiExc = null;
        try {
            UserTaskManager utm = (UserTaskManager)event.getSource();
            LanAdaptersBean beans = this;
            Object[] allBeans = utm.getDataObjects();
            String myBeanName = this.getClass().getName();
            int i = 0;
            while (i < allBeans.length) {
                String beanName = allBeans[i].getClass().getName();
                if (beanName.equals(myBeanName)) {
                    beans = (LanAdaptersBean)utm.getDataObjects()[i];
                }
                ++i;
            }
            String lanAdapter = this.getLanAdapter();
            int i2 = 0;
            while (!lanAdapter.equals(this.lanAdapterList[i2]) && i2 < this.num_LanAdapters) {
                Trace.trace(TRACE_MASKT, "LanAdaptersBean: (inside while) rowSelected = " + i2);
                ++i2;
            }
            Trace.trace(TRACE_MASKT, "LanAdaptersBean: (final) rowSelected = " + i2);
            this.rowSelected = new Integer(i2);
            PanelTaskletRequest request = new PanelTaskletRequest("lanadapterspanel");
            Trace.trace(TRACE_MASKT, "DETAILS_BUTTON pressed! Row selected = " + this.rowSelected);
            request.setData("panel", "lanadapterspanel");
            request.setData("action", "detailsButton");
            i2 = this.rowSelected;
            NetworkInterfaceInformation netif = (NetworkInterfaceInformation)this._ifs.get(i2);
            Trace.trace(TRACE_MASKT, "LanAdaptersBean: netif.getIpAddr() = " + netif.getIpAddr());
            request.setData("data", netif);
            request.setData("data2", this.rowSelected);
            this.postTaskletRequest(request);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Exception in action handler = " + exc);
            HException hexc = new HException(exc);
            new FrameworkLog(_logInfo, 16, hexc).log();
            this.dispose();
        }
        Trace.trace(TRACE_MASKT, "<- LanAdaptersBean.panelAction()");
    }

    public void parentalAction(TaskActionEvent event, PanelBean parent) {
        String command = event.getElementName();
        Trace.trace(TRACE_MASKF, "-> LanAdaptersBean.parentalAction() : " + command);
        PanelTaskletRequest request = new PanelTaskletRequest("lanadapterspanel");
        if (command.endsWith("okButton") || command.endsWith("applyButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (LanAdaptersBean) ");
            request.setData("panel", "lanadapterspanel");
            request.setData("action", "dataupdates");
            this.postTaskletRequest(request);
        } else if (command.endsWith("cancelButton")) {
            Trace.trace(TRACE_MASKT, command.substring(command.lastIndexOf(".") + 1) + " pressed! (LanAdaptersBean) ");
        }
        Trace.trace(TRACE_MASKF, "<- LanAdaptersBean.parentalAction()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> LanAdaptersBean.prepare()");
        this.m_cdLanAdapter = new ValueDescriptor[this.num_LanAdapters];
        int i = 0;
        while (i < this.num_LanAdapters) {
            this.m_cdLanAdapter[i] = new ValueDescriptor(this.lanAdapterList[i], this.lanAdapterList[i]);
            Trace.trace(TRACE_MASKT, "VDescr prepare: i= [" + i + "];  lanAdapterList[i] = [" + this.lanAdapterList[i] + "]");
            ++i;
        }
        if (this.num_LanAdapters > 0) {
            this.setLanAdapter(this.lanAdapterList[0]);
        }
        Trace.trace(TRACE_MASKT, "getLanAdapter() = [" + this.getLanAdapter() + "]");
        this.dataChangedFlag = false;
        Trace.trace(TRACE_MASKT, "<- LanAdaptersBean.prepare()");
    }

    public void update(Object updates) {
        Trace.trace(TRACE_MASKT, "-> LanAdaptersBean.update()");
        NetworkInterfaceInformation netif = (NetworkInterfaceInformation)updates;
        Trace.trace(TRACE_MASKT, "rowSelected.intValue() = " + this.rowSelected);
        Trace.trace(TRACE_MASKT, "CARDTYPES[netif.getAdapterType()] = " + SettingsConstants.CARDTYPES[netif.getAdapterType()]);
        Trace.trace(TRACE_MASKT, "netif.getIfname() = " + netif.getIfname());
        Trace.trace(TRACE_MASKT, "macaddrText = " + this.macaddrText[this.rowSelected]);
        Trace.trace(TRACE_MASKT, "netif.getIpAddr() " + netif.getIpAddr());
        Trace.trace(TRACE_MASKT, "netif.isConfigured() " + netif.isConfigured());
        this._ifs.set(this.rowSelected, netif);
        this.lanAdapterList[this.rowSelected.intValue()] = SettingsConstants.CARDTYPES[netif.getAdapterType()] + "  " + netif.getIfname() + "  " + this.macaddrText[this.rowSelected] + " (" + netif.getIpAddr() + ")";
        this.m_cdLanAdapter[this.rowSelected.intValue()] = new ValueDescriptor(this.lanAdapterList[this.rowSelected], this.lanAdapterList[this.rowSelected]);
        this.setLanAdapter(this.lanAdapterList[this.rowSelected]);
        this.userTaskManager.refreshElement(this.getMountPrefix() + "LanAdapter");
        Trace.trace(TRACE_MASKT, "address = " + netif.getIpAddr());
        Trace.trace(TRACE_MASKT, "<- LanAdaptersBean.update()");
    }

    public void setNetworkInterfaceList(List ifs) {
        Trace.trace(TRACE_MASKT, "-> LanAdaptersBean.setNetworkInterfaceList()");
        this.num_LanAdapters = ifs.size();
        this.lanAdapterList = new String[this.num_LanAdapters];
        Trace.trace(TRACE_MASKT, "num_LanAdapters = " + this.num_LanAdapters);
        if (this.num_LanAdapters > 0) {
            this.macaddrText = new String[this.num_LanAdapters];
            int i = 0;
            while (i < this.num_LanAdapters) {
                NetworkInterfaceInformation netif = (NetworkInterfaceInformation)ifs.get(i);
                String macaddress = netif.getMacAddress();
                int length = macaddress.length();
                this.macaddrText[i] = "";
                int j = 0;
                while (j < length && j < 24) {
                    this.macaddrText[i] = this.macaddrText[i] + macaddress.substring(j, j + 2);
                    if (j < length - 2) {
                        this.macaddrText[i] = this.macaddrText[i] + ":";
                    }
                    j += 2;
                }
                Trace.trace(TRACE_MASKT, "macaddrText[" + i + " = " + this.macaddrText[i]);
                this.lanAdapterList[i] = SettingsConstants.CARDTYPES[netif.getAdapterType()] + "  " + netif.getIfname() + "  " + this.macaddrText[i] + " (" + netif.getIpAddr() + ")";
                Trace.trace(TRACE_MASKT, "i = " + i + "; lanAdapterList[i] = " + this.lanAdapterList[i]);
                ++i;
            }
            this._ifs = ifs;
        }
        Trace.trace(TRACE_MASKT, "<- LanAdaptersBean.setNetworkInterfaceList()");
    }

    public void load() {
        this.m_sLanAdapter = "";
        this.m_cdLanAdapter = new ValueDescriptor[0];
    }
}

